package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeEffectivePolicyRequest(policyType: EffectivePolicyType, targetId: scala.Option[primitives.PolicyTargetId] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest = {
    import DescribeEffectivePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest.builder().policyType(policyType.unwrap).optionallyWith(targetId.map(value => value: java.lang.String))(_.targetId).build()
  }
  def asReadOnly: DescribeEffectivePolicyRequest.ReadOnly = DescribeEffectivePolicyRequest.wrap(buildAwsValue())
}
object DescribeEffectivePolicyRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeEffectivePolicyRequest = DescribeEffectivePolicyRequest(policyTypeValue, targetIdValue.map(value => value))
    def policyTypeValue: EffectivePolicyType
    def targetIdValue: scala.Option[primitives.PolicyTargetId]
    def policyType: ZIO[Any, Nothing, EffectivePolicyType] = ZIO.succeed(policyTypeValue)
    def targetId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.PolicyTargetId] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetId", targetIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest) extends DescribeEffectivePolicyRequest.ReadOnly {
    override def policyTypeValue: EffectivePolicyType = EffectivePolicyType.wrap(impl.policyType())
    override def targetIdValue: scala.Option[primitives.PolicyTargetId] = scala.Option(impl.targetId()).map(value => value: primitives.PolicyTargetId)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribeEffectivePolicyRequest): ReadOnly = new Wrapper(impl)
}