package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateOrganizationRequest(featureSet: scala.Option[OrganizationFeatureSet] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest = {
    import CreateOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest.builder().optionallyWith(featureSet.map(value => value.unwrap))(_.featureSet).build()
  }
  def asReadOnly: CreateOrganizationRequest.ReadOnly = CreateOrganizationRequest.wrap(buildAwsValue())
}
object CreateOrganizationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateOrganizationRequest = CreateOrganizationRequest(featureSetValue.map(value => value))
    def featureSetValue: scala.Option[OrganizationFeatureSet]
    def featureSet: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OrganizationFeatureSet] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("featureSet", featureSetValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest) extends CreateOrganizationRequest.ReadOnly { override def featureSetValue: scala.Option[OrganizationFeatureSet] = scala.Option(impl.featureSet()).map(value => OrganizationFeatureSet.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.CreateOrganizationRequest): ReadOnly = new Wrapper(impl)
}