package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateOrganizationalUnitRequest(organizationalUnitId: primitives.OrganizationalUnitId, name: scala.Option[primitives.OrganizationalUnitName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest = {
    import UpdateOrganizationalUnitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest.builder().organizationalUnitId(organizationalUnitId: java.lang.String).optionallyWith(name.map(value => value: java.lang.String))(_.name).build()
  }
  def asReadOnly: UpdateOrganizationalUnitRequest.ReadOnly = UpdateOrganizationalUnitRequest.wrap(buildAwsValue())
}
object UpdateOrganizationalUnitRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateOrganizationalUnitRequest = UpdateOrganizationalUnitRequest(organizationalUnitIdValue, nameValue.map(value => value))
    def organizationalUnitIdValue: primitives.OrganizationalUnitId
    def nameValue: scala.Option[primitives.OrganizationalUnitName]
    def organizationalUnitId: ZIO[Any, Nothing, primitives.OrganizationalUnitId] = ZIO.succeed(organizationalUnitIdValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.OrganizationalUnitName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest) extends UpdateOrganizationalUnitRequest.ReadOnly {
    override def organizationalUnitIdValue: primitives.OrganizationalUnitId = impl.organizationalUnitId(): primitives.OrganizationalUnitId
    override def nameValue: scala.Option[primitives.OrganizationalUnitName] = scala.Option(impl.name()).map(value => value: primitives.OrganizationalUnitName)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.UpdateOrganizationalUnitRequest): ReadOnly = new Wrapper(impl)
}