package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DelegatedService(servicePrincipal: scala.Option[primitives.ServicePrincipal] = None, delegationEnabledDate: scala.Option[primitives.Timestamp] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DelegatedService = {
    import DelegatedService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DelegatedService.builder().optionallyWith(servicePrincipal.map(value => value: java.lang.String))(_.servicePrincipal).optionallyWith(delegationEnabledDate.map(value => value: java.time.Instant))(_.delegationEnabledDate).build()
  }
  def asReadOnly: DelegatedService.ReadOnly = DelegatedService.wrap(buildAwsValue())
}
object DelegatedService {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DelegatedService] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DelegatedService = DelegatedService(servicePrincipalValue.map(value => value), delegationEnabledDateValue.map(value => value))
    def servicePrincipalValue: scala.Option[primitives.ServicePrincipal]
    def delegationEnabledDateValue: scala.Option[primitives.Timestamp]
    def servicePrincipal: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ServicePrincipal] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("servicePrincipal", servicePrincipalValue)
    def delegationEnabledDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("delegationEnabledDate", delegationEnabledDateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DelegatedService) extends DelegatedService.ReadOnly {
    override def servicePrincipalValue: scala.Option[primitives.ServicePrincipal] = scala.Option(impl.servicePrincipal()).map(value => value: primitives.ServicePrincipal)
    override def delegationEnabledDateValue: scala.Option[primitives.Timestamp] = scala.Option(impl.delegationEnabledDate()).map(value => value: primitives.Timestamp)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DelegatedService): ReadOnly = new Wrapper(impl)
}