package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UntagResourceRequest(resourceId: primitives.TaggableResourceId, tagKeys: Iterable[primitives.TagKey]) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.UntagResourceRequest.builder().resourceId(resourceId: java.lang.String).tagKeys(tagKeys.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: UntagResourceRequest.ReadOnly = UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.UntagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UntagResourceRequest = UntagResourceRequest(resourceIdValue, tagKeysValue)
    def resourceIdValue: primitives.TaggableResourceId
    def tagKeysValue: List[primitives.TagKey]
    def resourceId: ZIO[Any, Nothing, primitives.TaggableResourceId] = ZIO.succeed(resourceIdValue)
    def tagKeys: ZIO[Any, Nothing, List[primitives.TagKey]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.UntagResourceRequest) extends UntagResourceRequest.ReadOnly {
    override def resourceIdValue: primitives.TaggableResourceId = impl.resourceId(): primitives.TaggableResourceId
    override def tagKeysValue: List[primitives.TagKey] = impl.tagKeys().asScala.map { item => 
      item: primitives.TagKey
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.UntagResourceRequest): ReadOnly = new Wrapper(impl)
}