package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListPoliciesForTargetResponse(policies: scala.Option[Iterable[PolicySummary]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse = {
    import ListPoliciesForTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse.builder().optionallyWith(policies.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.policies).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListPoliciesForTargetResponse.ReadOnly = ListPoliciesForTargetResponse.wrap(buildAwsValue())
}
object ListPoliciesForTargetResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListPoliciesForTargetResponse = ListPoliciesForTargetResponse(policiesValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def policiesValue: scala.Option[List[PolicySummary.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def policies: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[PolicySummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("policies", policiesValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse) extends ListPoliciesForTargetResponse.ReadOnly {
    override def policiesValue: scala.Option[List[PolicySummary.ReadOnly]] = scala.Option(impl.policies()).map(value => value.asScala.map { item => 
      PolicySummary.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListPoliciesForTargetResponse): ReadOnly = new Wrapper(impl)
}