package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListHandshakesForOrganizationRequest(filter: scala.Option[HandshakeFilter] = None, nextToken: scala.Option[primitives.NextToken] = None, maxResults: scala.Option[primitives.MaxResults] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest = {
    import ListHandshakesForOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest.builder().optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).build()
  }
  def asReadOnly: ListHandshakesForOrganizationRequest.ReadOnly = ListHandshakesForOrganizationRequest.wrap(buildAwsValue())
}
object ListHandshakesForOrganizationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListHandshakesForOrganizationRequest = ListHandshakesForOrganizationRequest(filterValue.map(value => value.editable), nextTokenValue.map(value => value), maxResultsValue.map(value => value))
    def filterValue: scala.Option[HandshakeFilter.ReadOnly]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def maxResultsValue: scala.Option[primitives.MaxResults]
    def filter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HandshakeFilter.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filter", filterValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResults] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest) extends ListHandshakesForOrganizationRequest.ReadOnly {
    override def filterValue: scala.Option[HandshakeFilter.ReadOnly] = scala.Option(impl.filter()).map(value => HandshakeFilter.wrap(value))
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
    override def maxResultsValue: scala.Option[primitives.MaxResults] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResults)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListHandshakesForOrganizationRequest): ReadOnly = new Wrapper(impl)
}