package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListDelegatedAdministratorsResponse(delegatedAdministrators: scala.Option[Iterable[DelegatedAdministrator]] = None, nextToken: scala.Option[primitives.NextToken] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse = {
    import ListDelegatedAdministratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse.builder().optionallyWith(delegatedAdministrators.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.delegatedAdministrators).optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).build()
  }
  def asReadOnly: ListDelegatedAdministratorsResponse.ReadOnly = ListDelegatedAdministratorsResponse.wrap(buildAwsValue())
}
object ListDelegatedAdministratorsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListDelegatedAdministratorsResponse = ListDelegatedAdministratorsResponse(delegatedAdministratorsValue.map(value => value.map { item => 
      item.editable
    }), nextTokenValue.map(value => value))
    def delegatedAdministratorsValue: scala.Option[List[DelegatedAdministrator.ReadOnly]]
    def nextTokenValue: scala.Option[primitives.NextToken]
    def delegatedAdministrators: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DelegatedAdministrator.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("delegatedAdministrators", delegatedAdministratorsValue)
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse) extends ListDelegatedAdministratorsResponse.ReadOnly {
    override def delegatedAdministratorsValue: scala.Option[List[DelegatedAdministrator.ReadOnly]] = scala.Option(impl.delegatedAdministrators()).map(value => value.asScala.map { item => 
      DelegatedAdministrator.wrap(item)
    }.toList)
    override def nextTokenValue: scala.Option[primitives.NextToken] = scala.Option(impl.nextToken()).map(value => value: primitives.NextToken)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse): ReadOnly = new Wrapper(impl)
}