package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InviteAccountToOrganizationRequest(target: HandshakeParty, notes: scala.Option[primitives.HandshakeNotes] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest = {
    import InviteAccountToOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest.builder().target(target.buildAwsValue()).optionallyWith(notes.map(value => value: java.lang.String))(_.notes).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: InviteAccountToOrganizationRequest.ReadOnly = InviteAccountToOrganizationRequest.wrap(buildAwsValue())
}
object InviteAccountToOrganizationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InviteAccountToOrganizationRequest = InviteAccountToOrganizationRequest(targetValue.editable, notesValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def targetValue: HandshakeParty.ReadOnly
    def notesValue: scala.Option[primitives.HandshakeNotes]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def target: ZIO[Any, Nothing, HandshakeParty.ReadOnly] = ZIO.succeed(targetValue)
    def notes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.HandshakeNotes] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notes", notesValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest) extends InviteAccountToOrganizationRequest.ReadOnly {
    override def targetValue: HandshakeParty.ReadOnly = HandshakeParty.wrap(impl.target())
    override def notesValue: scala.Option[primitives.HandshakeNotes] = scala.Option(impl.notes()).map(value => value: primitives.HandshakeNotes)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.InviteAccountToOrganizationRequest): ReadOnly = new Wrapper(impl)
}