package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait HandshakePartyType { def unwrap: software.amazon.awssdk.services.organizations.model.HandshakePartyType }
object HandshakePartyType {
  def wrap(value: software.amazon.awssdk.services.organizations.model.HandshakePartyType): HandshakePartyType = value match {
    case software.amazon.awssdk.services.organizations.model.HandshakePartyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.organizations.model.HandshakePartyType.ACCOUNT =>
      val r = ACCOUNT
      r
    case software.amazon.awssdk.services.organizations.model.HandshakePartyType.ORGANIZATION =>
      val r = ORGANIZATION
      r
    case software.amazon.awssdk.services.organizations.model.HandshakePartyType.EMAIL =>
      val r = EMAIL
      r
  }
  case object unknownToSdkVersion extends HandshakePartyType { override def unwrap: software.amazon.awssdk.services.organizations.model.HandshakePartyType = software.amazon.awssdk.services.organizations.model.HandshakePartyType.UNKNOWN_TO_SDK_VERSION }
  case object ACCOUNT extends HandshakePartyType { override def unwrap: software.amazon.awssdk.services.organizations.model.HandshakePartyType = software.amazon.awssdk.services.organizations.model.HandshakePartyType.ACCOUNT }
  case object ORGANIZATION extends HandshakePartyType { override def unwrap: software.amazon.awssdk.services.organizations.model.HandshakePartyType = software.amazon.awssdk.services.organizations.model.HandshakePartyType.ORGANIZATION }
  case object EMAIL extends HandshakePartyType { override def unwrap: software.amazon.awssdk.services.organizations.model.HandshakePartyType = software.amazon.awssdk.services.organizations.model.HandshakePartyType.EMAIL }
}