package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeCreateAccountStatusResponse(createAccountStatus: scala.Option[CreateAccountStatus] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse = {
    import DescribeCreateAccountStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse.builder().optionallyWith(createAccountStatus.map(value => value.buildAwsValue()))(_.createAccountStatus).build()
  }
  def asReadOnly: DescribeCreateAccountStatusResponse.ReadOnly = DescribeCreateAccountStatusResponse.wrap(buildAwsValue())
}
object DescribeCreateAccountStatusResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeCreateAccountStatusResponse = DescribeCreateAccountStatusResponse(createAccountStatusValue.map(value => value.editable))
    def createAccountStatusValue: scala.Option[CreateAccountStatus.ReadOnly]
    def createAccountStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CreateAccountStatus.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createAccountStatus", createAccountStatusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse) extends DescribeCreateAccountStatusResponse.ReadOnly { override def createAccountStatusValue: scala.Option[CreateAccountStatus.ReadOnly] = scala.Option(impl.createAccountStatus()).map(value => CreateAccountStatus.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DescribeCreateAccountStatusResponse): ReadOnly = new Wrapper(impl)
}