package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeregisterDelegatedAdministratorRequest(accountId: primitives.AccountId, servicePrincipal: primitives.ServicePrincipal) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest = {
    import DeregisterDelegatedAdministratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest.builder().accountId(accountId: java.lang.String).servicePrincipal(servicePrincipal: java.lang.String).build()
  }
  def asReadOnly: DeregisterDelegatedAdministratorRequest.ReadOnly = DeregisterDelegatedAdministratorRequest.wrap(buildAwsValue())
}
object DeregisterDelegatedAdministratorRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeregisterDelegatedAdministratorRequest = DeregisterDelegatedAdministratorRequest(accountIdValue, servicePrincipalValue)
    def accountIdValue: primitives.AccountId
    def servicePrincipalValue: primitives.ServicePrincipal
    def accountId: ZIO[Any, Nothing, primitives.AccountId] = ZIO.succeed(accountIdValue)
    def servicePrincipal: ZIO[Any, Nothing, primitives.ServicePrincipal] = ZIO.succeed(servicePrincipalValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest) extends DeregisterDelegatedAdministratorRequest.ReadOnly {
    override def accountIdValue: primitives.AccountId = impl.accountId(): primitives.AccountId
    override def servicePrincipalValue: primitives.ServicePrincipal = impl.servicePrincipal(): primitives.ServicePrincipal
  }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DeregisterDelegatedAdministratorRequest): ReadOnly = new Wrapper(impl)
}