package io.github.vigoo.zioaws.organizations.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeclineHandshakeRequest(handshakeId: primitives.HandshakeId) {
  def buildAwsValue(): software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest = {
    import DeclineHandshakeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest.builder().handshakeId(handshakeId: java.lang.String).build()
  }
  def asReadOnly: DeclineHandshakeRequest.ReadOnly = DeclineHandshakeRequest.wrap(buildAwsValue())
}
object DeclineHandshakeRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeclineHandshakeRequest = DeclineHandshakeRequest(handshakeIdValue)
    def handshakeIdValue: primitives.HandshakeId
    def handshakeId: ZIO[Any, Nothing, primitives.HandshakeId] = ZIO.succeed(handshakeIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest) extends DeclineHandshakeRequest.ReadOnly { override def handshakeIdValue: primitives.HandshakeId = impl.handshakeId(): primitives.HandshakeId }
  def wrap(impl: software.amazon.awssdk.services.organizations.model.DeclineHandshakeRequest): ReadOnly = new Wrapper(impl)
}