package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDistributionResponse(
    operation: Option[io.github.vigoo.zioaws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse = {
    import UpdateDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse
      .wrap(buildAwsValue())
}
object UpdateDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse =
      io.github.vigoo.zioaws.lightsail.model
        .UpdateDistributionResponse(operationValue.map(value => value.editable))
    def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    def operation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ] = AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse.ReadOnly {
    override def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse
  ): io.github.vigoo.zioaws.lightsail.model.UpdateDistributionResponse.ReadOnly =
    new Wrapper(impl)
}
