package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  TagKey,
  ResourceArn,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceName: ResourceName,
    resourceArn: Option[ResourceArn] = None,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UntagResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.UntagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.UntagResourceRequest
      .wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.UntagResourceRequest =
      io.github.vigoo.zioaws.lightsail.model.UntagResourceRequest(
        resourceNameValue,
        resourceArnValue.map(value => value),
        tagKeysValue
      )
    def resourceNameValue: ResourceName
    def resourceArnValue: Option[ResourceArn]
    def tagKeysValue: List[TagKey]
    def resourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceNameValue)
    def resourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def tagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UntagResourceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.UntagResourceRequest.ReadOnly {
    override def resourceNameValue: ResourceName =
      impl.resourceName(): ResourceName
    override def resourceArnValue: Option[ResourceArn] =
      scala.Option(impl.resourceArn()).map(value => value: ResourceArn)
    override def tagKeysValue: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: TagKey
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UntagResourceRequest
  ): io.github.vigoo.zioaws.lightsail.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
