package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait TreatMissingData {
  def unwrap: software.amazon.awssdk.services.lightsail.model.TreatMissingData
}
object TreatMissingData {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.TreatMissingData
  ): io.github.vigoo.zioaws.lightsail.model.TreatMissingData = value match {
    case software.amazon.awssdk.services.lightsail.model.TreatMissingData.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.TreatMissingData.BREACHING =>
      val r = breaching
      r
    case software.amazon.awssdk.services.lightsail.model.TreatMissingData.NOT_BREACHING =>
      val r = notBreaching
      r
    case software.amazon.awssdk.services.lightsail.model.TreatMissingData.IGNORE =>
      val r = ignore
      r
    case software.amazon.awssdk.services.lightsail.model.TreatMissingData.MISSING =>
      val r = missing
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.TreatMissingData {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.TreatMissingData =
      software.amazon.awssdk.services.lightsail.model.TreatMissingData.UNKNOWN_TO_SDK_VERSION
  }
  case object breaching
      extends io.github.vigoo.zioaws.lightsail.model.TreatMissingData {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.TreatMissingData =
      software.amazon.awssdk.services.lightsail.model.TreatMissingData.BREACHING
  }
  case object notBreaching
      extends io.github.vigoo.zioaws.lightsail.model.TreatMissingData {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.TreatMissingData =
      software.amazon.awssdk.services.lightsail.model.TreatMissingData.NOT_BREACHING
  }
  case object ignore
      extends io.github.vigoo.zioaws.lightsail.model.TreatMissingData {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.TreatMissingData =
      software.amazon.awssdk.services.lightsail.model.TreatMissingData.IGNORE
  }
  case object missing
      extends io.github.vigoo.zioaws.lightsail.model.TreatMissingData {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.TreatMissingData =
      software.amazon.awssdk.services.lightsail.model.TreatMissingData.MISSING
  }
}
