package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetIpAddressTypeRequest(
    resourceType: io.github.vigoo.zioaws.lightsail.model.ResourceType,
    resourceName: ResourceName,
    ipAddressType: io.github.vigoo.zioaws.lightsail.model.IpAddressType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest = {
    import SetIpAddressTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest
      .builder()
      .resourceType(resourceType.unwrap)
      .resourceName(resourceName: java.lang.String)
      .ipAddressType(ipAddressType.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeRequest
      .wrap(buildAwsValue())
}
object SetIpAddressTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeRequest =
      io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeRequest(
        resourceTypeValue,
        resourceNameValue,
        ipAddressTypeValue
      )
    def resourceTypeValue: io.github.vigoo.zioaws.lightsail.model.ResourceType
    def resourceNameValue: ResourceName
    def ipAddressTypeValue: io.github.vigoo.zioaws.lightsail.model.IpAddressType
    def resourceType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = ZIO.succeed(resourceTypeValue)
    def resourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceNameValue)
    def ipAddressType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = ZIO.succeed(ipAddressTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeRequest.ReadOnly {
    override def resourceTypeValue
        : io.github.vigoo.zioaws.lightsail.model.ResourceType =
      io.github.vigoo.zioaws.lightsail.model.ResourceType
        .wrap(impl.resourceType())
    override def resourceNameValue: ResourceName =
      impl.resourceName(): ResourceName
    override def ipAddressTypeValue
        : io.github.vigoo.zioaws.lightsail.model.IpAddressType =
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
        .wrap(impl.ipAddressType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest
  ): io.github.vigoo.zioaws.lightsail.model.SetIpAddressTypeRequest.ReadOnly =
    new Wrapper(impl)
}
