package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendContactMethodVerificationRequest(
    protocol: io.github.vigoo.zioaws.lightsail.model.ContactMethodVerificationProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest = {
    import SendContactMethodVerificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest
      .builder()
      .protocol(protocol.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationRequest
      .wrap(buildAwsValue())
}
object SendContactMethodVerificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationRequest =
      io.github.vigoo.zioaws.lightsail.model
        .SendContactMethodVerificationRequest(protocolValue)
    def protocolValue
        : io.github.vigoo.zioaws.lightsail.model.ContactMethodVerificationProtocol
    def protocol: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.ContactMethodVerificationProtocol
    ] = ZIO.succeed(protocolValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationRequest.ReadOnly {
    override def protocolValue
        : io.github.vigoo.zioaws.lightsail.model.ContactMethodVerificationProtocol =
      io.github.vigoo.zioaws.lightsail.model.ContactMethodVerificationProtocol
        .wrap(impl.protocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest
  ): io.github.vigoo.zioaws.lightsail.model.SendContactMethodVerificationRequest.ReadOnly =
    new Wrapper(impl)
}
