package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Integer,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseSnapshot(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    engine: Option[NonEmptyString] = None,
    engineVersion: Option[NonEmptyString] = None,
    sizeInGb: Option[Integer] = None,
    state: Option[NonEmptyString] = None,
    fromRelationalDatabaseName: Option[NonEmptyString] = None,
    fromRelationalDatabaseArn: Option[NonEmptyString] = None,
    fromRelationalDatabaseBundleId: Option[String] = None,
    fromRelationalDatabaseBlueprintId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot = {
    import RelationalDatabaseSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        fromRelationalDatabaseName.map(value => value: java.lang.String)
      )(_.fromRelationalDatabaseName)
      .optionallyWith(
        fromRelationalDatabaseArn.map(value => value: java.lang.String)
      )(_.fromRelationalDatabaseArn)
      .optionallyWith(
        fromRelationalDatabaseBundleId.map(value => value: java.lang.String)
      )(_.fromRelationalDatabaseBundleId)
      .optionallyWith(
        fromRelationalDatabaseBlueprintId.map(value => value: java.lang.String)
      )(_.fromRelationalDatabaseBlueprintId)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot
      .wrap(buildAwsValue())
}
object RelationalDatabaseSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot =
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        engineValue.map(value => value),
        engineVersionValue.map(value => value),
        sizeInGbValue.map(value => value),
        stateValue.map(value => value),
        fromRelationalDatabaseNameValue.map(value => value),
        fromRelationalDatabaseArnValue.map(value => value),
        fromRelationalDatabaseBundleIdValue.map(value => value),
        fromRelationalDatabaseBlueprintIdValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def engineValue: Option[NonEmptyString]
    def engineVersionValue: Option[NonEmptyString]
    def sizeInGbValue: Option[Integer]
    def stateValue: Option[NonEmptyString]
    def fromRelationalDatabaseNameValue: Option[NonEmptyString]
    def fromRelationalDatabaseArnValue: Option[NonEmptyString]
    def fromRelationalDatabaseBundleIdValue: Option[String]
    def fromRelationalDatabaseBlueprintIdValue: Option[String]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def engine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def sizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
    def state: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", stateValue)
    def fromRelationalDatabaseName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "fromRelationalDatabaseName",
        fromRelationalDatabaseNameValue
      )
    def fromRelationalDatabaseArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "fromRelationalDatabaseArn",
        fromRelationalDatabaseArnValue
      )
    def fromRelationalDatabaseBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "fromRelationalDatabaseBundleId",
        fromRelationalDatabaseBundleIdValue
      )
    def fromRelationalDatabaseBlueprintId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "fromRelationalDatabaseBlueprintId",
        fromRelationalDatabaseBlueprintIdValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot
  ) extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def engineValue: Option[NonEmptyString] =
      scala.Option(impl.engine()).map(value => value: NonEmptyString)
    override def engineVersionValue: Option[NonEmptyString] =
      scala.Option(impl.engineVersion()).map(value => value: NonEmptyString)
    override def sizeInGbValue: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
    override def stateValue: Option[NonEmptyString] =
      scala.Option(impl.state()).map(value => value: NonEmptyString)
    override def fromRelationalDatabaseNameValue: Option[NonEmptyString] = scala
      .Option(impl.fromRelationalDatabaseName())
      .map(value => value: NonEmptyString)
    override def fromRelationalDatabaseArnValue: Option[NonEmptyString] = scala
      .Option(impl.fromRelationalDatabaseArn())
      .map(value => value: NonEmptyString)
    override def fromRelationalDatabaseBundleIdValue: Option[String] = scala
      .Option(impl.fromRelationalDatabaseBundleId())
      .map(value => value: String)
    override def fromRelationalDatabaseBlueprintIdValue: Option[String] = scala
      .Option(impl.fromRelationalDatabaseBlueprintId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot
  ): io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly =
    new Wrapper(impl)
}
