package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseParameter(
    allowedValues: Option[String] = None,
    applyMethod: Option[String] = None,
    applyType: Option[String] = None,
    dataType: Option[String] = None,
    description: Option[String] = None,
    isModifiable: Option[Boolean] = None,
    parameterName: Option[String] = None,
    parameterValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter = {
    import RelationalDatabaseParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
      .builder()
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(applyMethod.map(value => value: java.lang.String))(
        _.applyMethod
      )
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter
      .wrap(buildAwsValue())
}
object RelationalDatabaseParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter =
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter(
        allowedValuesValue.map(value => value),
        applyMethodValue.map(value => value),
        applyTypeValue.map(value => value),
        dataTypeValue.map(value => value),
        descriptionValue.map(value => value),
        isModifiableValue.map(value => value),
        parameterNameValue.map(value => value),
        parameterValueValue.map(value => value)
      )
    def allowedValuesValue: Option[String]
    def applyMethodValue: Option[String]
    def applyTypeValue: Option[String]
    def dataTypeValue: Option[String]
    def descriptionValue: Option[String]
    def isModifiableValue: Option[Boolean]
    def parameterNameValue: Option[String]
    def parameterValueValue: Option[String]
    def allowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValuesValue)
    def applyMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyMethod", applyMethodValue)
    def applyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyTypeValue)
    def dataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataTypeValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def isModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiableValue)
    def parameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterNameValue)
    def parameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
  ) extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter.ReadOnly {
    override def allowedValuesValue: Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override def applyMethodValue: Option[String] =
      scala.Option(impl.applyMethod()).map(value => value: String)
    override def applyTypeValue: Option[String] =
      scala.Option(impl.applyType()).map(value => value: String)
    override def dataTypeValue: Option[String] =
      scala.Option(impl.dataType()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def isModifiableValue: Option[Boolean] =
      scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override def parameterNameValue: Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override def parameterValueValue: Option[String] =
      scala.Option(impl.parameterValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
  ): io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter.ReadOnly =
    new Wrapper(impl)
}
