package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait RelationalDatabaseMetricName {
  def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName
}
object RelationalDatabaseMetricName {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName
  ): io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName =
    value match {
      case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.CPU_UTILIZATION =>
        val r = CPUUtilization
        r
      case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.DATABASE_CONNECTIONS =>
        val r = DatabaseConnections
        r
      case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.DISK_QUEUE_DEPTH =>
        val r = DiskQueueDepth
        r
      case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.FREE_STORAGE_SPACE =>
        val r = FreeStorageSpace
        r
      case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.NETWORK_RECEIVE_THROUGHPUT =>
        val r = NetworkReceiveThroughput
        r
      case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.NETWORK_TRANSMIT_THROUGHPUT =>
        val r = NetworkTransmitThroughput
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object CPUUtilization
      extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.CPU_UTILIZATION
  }
  case object DatabaseConnections
      extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.DATABASE_CONNECTIONS
  }
  case object DiskQueueDepth
      extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.DISK_QUEUE_DEPTH
  }
  case object FreeStorageSpace
      extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.FREE_STORAGE_SPACE
  }
  case object NetworkReceiveThroughput
      extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.NETWORK_RECEIVE_THROUGHPUT
  }
  case object NetworkTransmitThroughput
      extends io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.NETWORK_TRANSMIT_THROUGHPUT
  }
}
