package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Region(
    continentCode: Option[String] = None,
    description: Option[String] = None,
    displayName: Option[String] = None,
    name: Option[io.github.vigoo.zioaws.lightsail.model.RegionName] = None,
    availabilityZones: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AvailabilityZone]
    ] = None,
    relationalDatabaseAvailabilityZones: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AvailabilityZone]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Region = {
    import Region.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Region
      .builder()
      .optionallyWith(continentCode.map(value => value: java.lang.String))(
        _.continentCode
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        relationalDatabaseAvailabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationalDatabaseAvailabilityZones)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Region.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Region.wrap(buildAwsValue())
}
object Region {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Region] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Region =
      io.github.vigoo.zioaws.lightsail.model.Region(
        continentCodeValue.map(value => value),
        descriptionValue.map(value => value),
        displayNameValue.map(value => value),
        nameValue.map(value => value),
        availabilityZonesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        relationalDatabaseAvailabilityZonesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def continentCodeValue: Option[String]
    def descriptionValue: Option[String]
    def displayNameValue: Option[String]
    def nameValue: Option[io.github.vigoo.zioaws.lightsail.model.RegionName]
    def availabilityZonesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.ReadOnly]
    ]
    def relationalDatabaseAvailabilityZonesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.ReadOnly]
    ]
    def continentCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("continentCode", continentCodeValue)
    def description: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def displayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayNameValue)
    def name: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RegionName
    ] = AwsError.unwrapOptionField("name", nameValue)
    def availabilityZones: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZonesValue)
    def relationalDatabaseAvailabilityZones: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relationalDatabaseAvailabilityZones",
      relationalDatabaseAvailabilityZonesValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Region
  ) extends io.github.vigoo.zioaws.lightsail.model.Region.ReadOnly {
    override def continentCodeValue: Option[String] =
      scala.Option(impl.continentCode()).map(value => value: String)
    override def descriptionValue: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override def displayNameValue: Option[String] =
      scala.Option(impl.displayName()).map(value => value: String)
    override def nameValue
        : Option[io.github.vigoo.zioaws.lightsail.model.RegionName] = scala
      .Option(impl.name())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RegionName.wrap(value)
      )
    override def availabilityZonesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.ReadOnly]
    ] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.wrap(item)
        }.toList
      )
    override def relationalDatabaseAvailabilityZonesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.ReadOnly]
    ] = scala
      .Option(impl.relationalDatabaseAvailabilityZones())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.AvailabilityZone.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Region
  ): io.github.vigoo.zioaws.lightsail.model.Region.ReadOnly = new Wrapper(impl)
}
