package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Origin(
    name: Option[ResourceName] = None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    regionName: Option[io.github.vigoo.zioaws.lightsail.model.RegionName] =
      None,
    protocolPolicy: Option[
      io.github.vigoo.zioaws.lightsail.model.OriginProtocolPolicyEnum
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Origin = {
    import Origin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Origin
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(regionName.map(value => value.unwrap))(_.regionName)
      .optionallyWith(protocolPolicy.map(value => value.unwrap))(
        _.protocolPolicy
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Origin.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Origin.wrap(buildAwsValue())
}
object Origin {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Origin] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Origin =
      io.github.vigoo.zioaws.lightsail.model.Origin(
        nameValue.map(value => value),
        resourceTypeValue.map(value => value),
        regionNameValue.map(value => value),
        protocolPolicyValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def regionNameValue
        : Option[io.github.vigoo.zioaws.lightsail.model.RegionName]
    def protocolPolicyValue: Option[
      io.github.vigoo.zioaws.lightsail.model.OriginProtocolPolicyEnum
    ]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def regionName: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RegionName
    ] = AwsError.unwrapOptionField("regionName", regionNameValue)
    def protocolPolicy: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.OriginProtocolPolicyEnum
    ] = AwsError.unwrapOptionField("protocolPolicy", protocolPolicyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Origin
  ) extends io.github.vigoo.zioaws.lightsail.model.Origin.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def regionNameValue
        : Option[io.github.vigoo.zioaws.lightsail.model.RegionName] = scala
      .Option(impl.regionName())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RegionName.wrap(value)
      )
    override def protocolPolicyValue: Option[
      io.github.vigoo.zioaws.lightsail.model.OriginProtocolPolicyEnum
    ] = scala
      .Option(impl.protocolPolicy())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.OriginProtocolPolicyEnum
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Origin
  ): io.github.vigoo.zioaws.lightsail.model.Origin.ReadOnly = new Wrapper(impl)
}
