package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OpenInstancePublicPortsRequest(
    portInfo: io.github.vigoo.zioaws.lightsail.model.PortInfo,
    instanceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest = {
    import OpenInstancePublicPortsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest
      .builder()
      .portInfo(portInfo.buildAwsValue())
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsRequest
      .wrap(buildAwsValue())
}
object OpenInstancePublicPortsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsRequest =
      io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsRequest(
        portInfoValue.editable,
        instanceNameValue
      )
    def portInfoValue: io.github.vigoo.zioaws.lightsail.model.PortInfo.ReadOnly
    def instanceNameValue: ResourceName
    def portInfo: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.PortInfo.ReadOnly
    ] = ZIO.succeed(portInfoValue)
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsRequest.ReadOnly {
    override def portInfoValue
        : io.github.vigoo.zioaws.lightsail.model.PortInfo.ReadOnly =
      io.github.vigoo.zioaws.lightsail.model.PortInfo.wrap(impl.portInfo())
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest
  ): io.github.vigoo.zioaws.lightsail.model.OpenInstancePublicPortsRequest.ReadOnly =
    new Wrapper(impl)
}
