package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.IsoDate
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LogEvent(
    createdAt: Option[IsoDate] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LogEvent = {
    import LogEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LogEvent
      .builder()
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.LogEvent.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.LogEvent.wrap(buildAwsValue())
}
object LogEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LogEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.LogEvent =
      io.github.vigoo.zioaws.lightsail.model.LogEvent(
        createdAtValue.map(value => value),
        messageValue.map(value => value)
      )
    def createdAtValue: Option[IsoDate]
    def messageValue: Option[String]
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def message: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LogEvent
  ) extends io.github.vigoo.zioaws.lightsail.model.LogEvent.ReadOnly {
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def messageValue: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LogEvent
  ): io.github.vigoo.zioaws.lightsail.model.LogEvent.ReadOnly = new Wrapper(
    impl
  )
}
