package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.DomainName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoadBalancerTlsCertificateDomainValidationOption(
    domainName: Option[DomainName] = None,
    validationStatus: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption = {
    import LoadBalancerTlsCertificateDomainValidationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
      .builder()
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(validationStatus.map(value => value.unwrap))(
        _.validationStatus
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateDomainValidationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption =
      io.github.vigoo.zioaws.lightsail.model
        .LoadBalancerTlsCertificateDomainValidationOption(
          domainNameValue.map(value => value),
          validationStatusValue.map(value => value)
        )
    def domainNameValue: Option[DomainName]
    def validationStatusValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ]
    def domainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainNameValue)
    def validationStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = AwsError.unwrapOptionField("validationStatus", validationStatusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ) extends io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly {
    override def domainNameValue: Option[DomainName] =
      scala.Option(impl.domainName()).map(value => value: DomainName)
    override def validationStatusValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = scala
      .Option(impl.validationStatus())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ): io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly =
    new Wrapper(impl)
}
