package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  Port,
  Integer,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoadBalancer(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    dnsName: Option[NonEmptyString] = None,
    state: Option[io.github.vigoo.zioaws.lightsail.model.LoadBalancerState] =
      None,
    protocol: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerProtocol
    ] = None,
    publicPorts: Option[Iterable[Port]] = None,
    healthCheckPath: Option[NonEmptyString] = None,
    instancePort: Option[Integer] = None,
    instanceHealthSummary: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary]
    ] = None,
    tlsCertificateSummaries: Option[Iterable[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary
    ]] = None,
    configurationOptions: Option[Map[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName,
      String
    ]] = None,
    ipAddressType: Option[
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancer = {
    import LoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancer
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(dnsName.map(value => value: java.lang.String))(_.dnsName)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        publicPorts.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.publicPorts)
      .optionallyWith(healthCheckPath.map(value => value: java.lang.String))(
        _.healthCheckPath
      )
      .optionallyWith(instancePort.map(value => value: java.lang.Integer))(
        _.instancePort
      )
      .optionallyWith(
        instanceHealthSummary.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceHealthSummary)
      .optionallyWith(
        tlsCertificateSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tlsCertificateSummaries)
      .optionallyWith(
        configurationOptions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.configurationOptionsWithStrings)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.LoadBalancer.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.LoadBalancer.wrap(buildAwsValue())
}
object LoadBalancer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.LoadBalancer =
      io.github.vigoo.zioaws.lightsail.model.LoadBalancer(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        dnsNameValue.map(value => value),
        stateValue.map(value => value),
        protocolValue.map(value => value),
        publicPortsValue.map(value => value),
        healthCheckPathValue.map(value => value),
        instancePortValue.map(value => value),
        instanceHealthSummaryValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        tlsCertificateSummariesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        configurationOptionsValue.map(value => value),
        ipAddressTypeValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def dnsNameValue: Option[NonEmptyString]
    def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.LoadBalancerState]
    def protocolValue
        : Option[io.github.vigoo.zioaws.lightsail.model.LoadBalancerProtocol]
    def publicPortsValue: Option[List[Port]]
    def healthCheckPathValue: Option[NonEmptyString]
    def instancePortValue: Option[Integer]
    def instanceHealthSummaryValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary.ReadOnly
    ]]
    def tlsCertificateSummariesValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly
    ]]
    def configurationOptionsValue: Option[Map[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName,
      String
    ]]
    def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def dnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dnsName", dnsNameValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def protocol: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerProtocol
    ] = AwsError.unwrapOptionField("protocol", protocolValue)
    def publicPorts: ZIO[Any, AwsError, List[Port]] =
      AwsError.unwrapOptionField("publicPorts", publicPortsValue)
    def healthCheckPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("healthCheckPath", healthCheckPathValue)
    def instancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instancePort", instancePortValue)
    def instanceHealthSummary: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceHealthSummary",
      instanceHealthSummaryValue
    )
    def tlsCertificateSummaries: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "tlsCertificateSummaries",
      tlsCertificateSummariesValue
    )
    def configurationOptions: ZIO[Any, AwsError, Map[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName,
      String
    ]] = AwsError.unwrapOptionField(
      "configurationOptions",
      configurationOptionsValue
    )
    def ipAddressType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancer
  ) extends io.github.vigoo.zioaws.lightsail.model.LoadBalancer.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def dnsNameValue: Option[NonEmptyString] =
      scala.Option(impl.dnsName()).map(value => value: NonEmptyString)
    override def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.LoadBalancerState] =
      scala
        .Option(impl.state())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.LoadBalancerState.wrap(value)
        )
    override def protocolValue
        : Option[io.github.vigoo.zioaws.lightsail.model.LoadBalancerProtocol] =
      scala
        .Option(impl.protocol())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.LoadBalancerProtocol
            .wrap(value)
        )
    override def publicPortsValue: Option[List[Port]] = scala
      .Option(impl.publicPorts())
      .map(value =>
        value.asScala.map { item =>
          item: Port
        }.toList
      )
    override def healthCheckPathValue: Option[NonEmptyString] =
      scala.Option(impl.healthCheckPath()).map(value => value: NonEmptyString)
    override def instancePortValue: Option[Integer] =
      scala.Option(impl.instancePort()).map(value => value: Integer)
    override def instanceHealthSummaryValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary.ReadOnly
    ]] = scala
      .Option(impl.instanceHealthSummary())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.InstanceHealthSummary
            .wrap(item)
        }.toList
      )
    override def tlsCertificateSummariesValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly
    ]] = scala
      .Option(impl.tlsCertificateSummaries())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateSummary
            .wrap(item)
        }.toList
      )
    override def configurationOptionsValue: Option[Map[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName,
      String
    ]] = scala
      .Option(impl.configurationOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            io.github.vigoo.zioaws.lightsail.model.LoadBalancerAttributeName
              .wrap(key) -> (value: String)
          })
          .toMap
      )
    override def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.IpAddressType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancer
  ): io.github.vigoo.zioaws.lightsail.model.LoadBalancer.ReadOnly = new Wrapper(
    impl
  )
}
