package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LightsailDistribution(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    alternativeDomainNames: Option[Iterable[String]] = None,
    status: Option[String] = None,
    isEnabled: Option[Boolean] = None,
    domainName: Option[String] = None,
    bundleId: Option[String] = None,
    certificateName: Option[ResourceName] = None,
    origin: Option[io.github.vigoo.zioaws.lightsail.model.Origin] = None,
    originPublicDNS: Option[String] = None,
    defaultCacheBehavior: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheBehavior
    ] = None,
    cacheBehaviorSettings: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheSettings
    ] = None,
    cacheBehaviors: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath]
    ] = None,
    ableToUpdateBundle: Option[Boolean] = None,
    ipAddressType: Option[
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LightsailDistribution = {
    import LightsailDistribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LightsailDistribution
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        alternativeDomainNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.alternativeDomainNames)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(isEnabled.map(value => value: java.lang.Boolean))(
        _.isEnabled
      )
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(certificateName.map(value => value: java.lang.String))(
        _.certificateName
      )
      .optionallyWith(origin.map(value => value.buildAwsValue()))(_.origin)
      .optionallyWith(originPublicDNS.map(value => value: java.lang.String))(
        _.originPublicDNS
      )
      .optionallyWith(defaultCacheBehavior.map(value => value.buildAwsValue()))(
        _.defaultCacheBehavior
      )
      .optionallyWith(
        cacheBehaviorSettings.map(value => value.buildAwsValue())
      )(_.cacheBehaviorSettings)
      .optionallyWith(
        cacheBehaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheBehaviors)
      .optionallyWith(
        ableToUpdateBundle.map(value => value: java.lang.Boolean)
      )(_.ableToUpdateBundle)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.LightsailDistribution
      .wrap(buildAwsValue())
}
object LightsailDistribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LightsailDistribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.LightsailDistribution =
      io.github.vigoo.zioaws.lightsail.model.LightsailDistribution(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        alternativeDomainNamesValue.map(value => value),
        statusValue.map(value => value),
        isEnabledValue.map(value => value),
        domainNameValue.map(value => value),
        bundleIdValue.map(value => value),
        certificateNameValue.map(value => value),
        originValue.map(value => value.editable),
        originPublicDNSValue.map(value => value),
        defaultCacheBehaviorValue.map(value => value.editable),
        cacheBehaviorSettingsValue.map(value => value.editable),
        cacheBehaviorsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        ableToUpdateBundleValue.map(value => value),
        ipAddressTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def alternativeDomainNamesValue: Option[List[String]]
    def statusValue: Option[String]
    def isEnabledValue: Option[Boolean]
    def domainNameValue: Option[String]
    def bundleIdValue: Option[String]
    def certificateNameValue: Option[ResourceName]
    def originValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Origin.ReadOnly]
    def originPublicDNSValue: Option[String]
    def defaultCacheBehaviorValue
        : Option[io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly]
    def cacheBehaviorSettingsValue
        : Option[io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly]
    def cacheBehaviorsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly]
    ]
    def ableToUpdateBundleValue: Option[Boolean]
    def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def alternativeDomainNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("alternativeDomainNames", alternativeDomainNamesValue)
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def isEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEnabled", isEnabledValue)
    def domainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainName", domainNameValue)
    def bundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def certificateName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("certificateName", certificateNameValue)
    def origin: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Origin.ReadOnly
    ] = AwsError.unwrapOptionField("origin", originValue)
    def originPublicDNS: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originPublicDNS", originPublicDNSValue)
    def defaultCacheBehavior: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultCacheBehavior",
      defaultCacheBehaviorValue
    )
    def cacheBehaviorSettings: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cacheBehaviorSettings",
      cacheBehaviorSettingsValue
    )
    def cacheBehaviors: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviorsValue)
    def ableToUpdateBundle: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ableToUpdateBundle", ableToUpdateBundleValue)
    def ipAddressType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LightsailDistribution
  ) extends io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def alternativeDomainNamesValue: Option[List[String]] = scala
      .Option(impl.alternativeDomainNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def isEnabledValue: Option[Boolean] =
      scala.Option(impl.isEnabled()).map(value => value: Boolean)
    override def domainNameValue: Option[String] =
      scala.Option(impl.domainName()).map(value => value: String)
    override def bundleIdValue: Option[String] =
      scala.Option(impl.bundleId()).map(value => value: String)
    override def certificateNameValue: Option[ResourceName] =
      scala.Option(impl.certificateName()).map(value => value: ResourceName)
    override def originValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Origin.ReadOnly] = scala
      .Option(impl.origin())
      .map(value => io.github.vigoo.zioaws.lightsail.model.Origin.wrap(value))
    override def originPublicDNSValue: Option[String] =
      scala.Option(impl.originPublicDNS()).map(value => value: String)
    override def defaultCacheBehaviorValue: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly
    ] = scala
      .Option(impl.defaultCacheBehavior())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.CacheBehavior.wrap(value)
      )
    override def cacheBehaviorSettingsValue: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly
    ] = scala
      .Option(impl.cacheBehaviorSettings())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.CacheSettings.wrap(value)
      )
    override def cacheBehaviorsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly]
    ] = scala
      .Option(impl.cacheBehaviors())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.wrap(item)
        }.toList
      )
    override def ableToUpdateBundleValue: Option[Boolean] =
      scala.Option(impl.ableToUpdateBundle()).map(value => value: Boolean)
    override def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.IpAddressType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LightsailDistribution
  ): io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.ReadOnly =
    new Wrapper(impl)
}
