package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IsVpcPeeredResponse(isPeered: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse = {
    import IsVpcPeeredResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse
      .builder()
      .optionallyWith(isPeered.map(value => value: java.lang.Boolean))(
        _.isPeered
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse
      .wrap(buildAwsValue())
}
object IsVpcPeeredResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse =
      io.github.vigoo.zioaws.lightsail.model
        .IsVpcPeeredResponse(isPeeredValue.map(value => value))
    def isPeeredValue: Option[Boolean]
    def isPeered: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPeered", isPeeredValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse.ReadOnly {
    override def isPeeredValue: Option[Boolean] =
      scala.Option(impl.isPeered()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse
  ): io.github.vigoo.zioaws.lightsail.model.IsVpcPeeredResponse.ReadOnly =
    new Wrapper(impl)
}
