package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceState(
    code: Option[Integer] = None,
    name: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceState = {
    import InstanceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceState
      .builder()
      .optionallyWith(code.map(value => value: java.lang.Integer))(_.code)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.InstanceState.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.InstanceState.wrap(buildAwsValue())
}
object InstanceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.InstanceState =
      io.github.vigoo.zioaws.lightsail.model.InstanceState(
        codeValue.map(value => value),
        nameValue.map(value => value)
      )
    def codeValue: Option[Integer]
    def nameValue: Option[String]
    def code: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("code", codeValue)
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceState
  ) extends io.github.vigoo.zioaws.lightsail.model.InstanceState.ReadOnly {
    override def codeValue: Option[Integer] =
      scala.Option(impl.code()).map(value => value: Integer)
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceState
  ): io.github.vigoo.zioaws.lightsail.model.InstanceState.ReadOnly =
    new Wrapper(impl)
}
