package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceSnapshotInfo(
    fromBundleId: Option[NonEmptyString] = None,
    fromBlueprintId: Option[NonEmptyString] = None,
    fromDiskInfo: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.DiskInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo = {
    import InstanceSnapshotInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
      .builder()
      .optionallyWith(fromBundleId.map(value => value: java.lang.String))(
        _.fromBundleId
      )
      .optionallyWith(fromBlueprintId.map(value => value: java.lang.String))(
        _.fromBlueprintId
      )
      .optionallyWith(
        fromDiskInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fromDiskInfo)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo
      .wrap(buildAwsValue())
}
object InstanceSnapshotInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo =
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo(
        fromBundleIdValue.map(value => value),
        fromBlueprintIdValue.map(value => value),
        fromDiskInfoValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def fromBundleIdValue: Option[NonEmptyString]
    def fromBlueprintIdValue: Option[NonEmptyString]
    def fromDiskInfoValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.DiskInfo.ReadOnly]]
    def fromBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromBundleId", fromBundleIdValue)
    def fromBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromBlueprintId", fromBlueprintIdValue)
    def fromDiskInfo: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.DiskInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("fromDiskInfo", fromDiskInfoValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
  ) extends io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo.ReadOnly {
    override def fromBundleIdValue: Option[NonEmptyString] =
      scala.Option(impl.fromBundleId()).map(value => value: NonEmptyString)
    override def fromBlueprintIdValue: Option[NonEmptyString] =
      scala.Option(impl.fromBlueprintId()).map(value => value: NonEmptyString)
    override def fromDiskInfoValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.DiskInfo.ReadOnly]
    ] = scala
      .Option(impl.fromDiskInfo())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.DiskInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
  ): io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo.ReadOnly =
    new Wrapper(impl)
}
