package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait InstancePlatform {
  def unwrap: software.amazon.awssdk.services.lightsail.model.InstancePlatform
}
object InstancePlatform {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.InstancePlatform
  ): io.github.vigoo.zioaws.lightsail.model.InstancePlatform = value match {
    case software.amazon.awssdk.services.lightsail.model.InstancePlatform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.InstancePlatform.LINUX_UNIX =>
      val r = LINUX_UNIX
      r
    case software.amazon.awssdk.services.lightsail.model.InstancePlatform.WINDOWS =>
      val r = WINDOWS
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.InstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstancePlatform =
      software.amazon.awssdk.services.lightsail.model.InstancePlatform.UNKNOWN_TO_SDK_VERSION
  }
  case object LINUX_UNIX
      extends io.github.vigoo.zioaws.lightsail.model.InstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstancePlatform =
      software.amazon.awssdk.services.lightsail.model.InstancePlatform.LINUX_UNIX
  }
  case object WINDOWS
      extends io.github.vigoo.zioaws.lightsail.model.InstancePlatform {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstancePlatform =
      software.amazon.awssdk.services.lightsail.model.InstancePlatform.WINDOWS
  }
}
