package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait InstanceAccessProtocol {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol
}
object InstanceAccessProtocol {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol
  ): io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol =
    value match {
      case software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol.SSH =>
        val r = ssh
        r
      case software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol.RDP =>
        val r = rdp
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol =
      software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object ssh
      extends io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol =
      software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol.SSH
  }
  case object rdp
      extends io.github.vigoo.zioaws.lightsail.model.InstanceAccessProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol =
      software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol.RDP
  }
}
