package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.IsoDate
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HostKeyAttributes(
    algorithm: Option[String] = None,
    publicKey: Option[String] = None,
    witnessedAt: Option[IsoDate] = None,
    fingerprintSHA1: Option[String] = None,
    fingerprintSHA256: Option[String] = None,
    notValidBefore: Option[IsoDate] = None,
    notValidAfter: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.HostKeyAttributes = {
    import HostKeyAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.HostKeyAttributes
      .builder()
      .optionallyWith(algorithm.map(value => value: java.lang.String))(
        _.algorithm
      )
      .optionallyWith(publicKey.map(value => value: java.lang.String))(
        _.publicKey
      )
      .optionallyWith(witnessedAt.map(value => value: Instant))(_.witnessedAt)
      .optionallyWith(fingerprintSHA1.map(value => value: java.lang.String))(
        _.fingerprintSHA1
      )
      .optionallyWith(fingerprintSHA256.map(value => value: java.lang.String))(
        _.fingerprintSHA256
      )
      .optionallyWith(notValidBefore.map(value => value: Instant))(
        _.notValidBefore
      )
      .optionallyWith(notValidAfter.map(value => value: Instant))(
        _.notValidAfter
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes
      .wrap(buildAwsValue())
}
object HostKeyAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.HostKeyAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes =
      io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes(
        algorithmValue.map(value => value),
        publicKeyValue.map(value => value),
        witnessedAtValue.map(value => value),
        fingerprintSHA1Value.map(value => value),
        fingerprintSHA256Value.map(value => value),
        notValidBeforeValue.map(value => value),
        notValidAfterValue.map(value => value)
      )
    def algorithmValue: Option[String]
    def publicKeyValue: Option[String]
    def witnessedAtValue: Option[IsoDate]
    def fingerprintSHA1Value: Option[String]
    def fingerprintSHA256Value: Option[String]
    def notValidBeforeValue: Option[IsoDate]
    def notValidAfterValue: Option[IsoDate]
    def algorithm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("algorithm", algorithmValue)
    def publicKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicKey", publicKeyValue)
    def witnessedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("witnessedAt", witnessedAtValue)
    def fingerprintSHA1: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fingerprintSHA1", fingerprintSHA1Value)
    def fingerprintSHA256: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fingerprintSHA256", fingerprintSHA256Value)
    def notValidBefore: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notValidBefore", notValidBeforeValue)
    def notValidAfter: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notValidAfter", notValidAfterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.HostKeyAttributes
  ) extends io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes.ReadOnly {
    override def algorithmValue: Option[String] =
      scala.Option(impl.algorithm()).map(value => value: String)
    override def publicKeyValue: Option[String] =
      scala.Option(impl.publicKey()).map(value => value: String)
    override def witnessedAtValue: Option[IsoDate] =
      scala.Option(impl.witnessedAt()).map(value => value: IsoDate)
    override def fingerprintSHA1Value: Option[String] =
      scala.Option(impl.fingerprintSHA1()).map(value => value: String)
    override def fingerprintSHA256Value: Option[String] =
      scala.Option(impl.fingerprintSHA256()).map(value => value: String)
    override def notValidBeforeValue: Option[IsoDate] =
      scala.Option(impl.notValidBefore()).map(value => value: IsoDate)
    override def notValidAfterValue: Option[IsoDate] =
      scala.Option(impl.notValidAfter()).map(value => value: IsoDate)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.HostKeyAttributes
  ): io.github.vigoo.zioaws.lightsail.model.HostKeyAttributes.ReadOnly =
    new Wrapper(impl)
}
