package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait HeaderEnum {
  def unwrap: software.amazon.awssdk.services.lightsail.model.HeaderEnum
}
object HeaderEnum {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.HeaderEnum
  ): io.github.vigoo.zioaws.lightsail.model.HeaderEnum = value match {
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT =>
      val r = Accept
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT_CHARSET =>
      val r = `Accept-Charset`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT_DATETIME =>
      val r = `Accept-Datetime`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT_ENCODING =>
      val r = `Accept-Encoding`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT_LANGUAGE =>
      val r = `Accept-Language`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.AUTHORIZATION =>
      val r = Authorization
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_FORWARDED_PROTO =>
      val r = `CloudFront-Forwarded-Proto`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_IS_DESKTOP_VIEWER =>
      val r = `CloudFront-Is-Desktop-Viewer`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_IS_MOBILE_VIEWER =>
      val r = `CloudFront-Is-Mobile-Viewer`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_IS_SMART_TV_VIEWER =>
      val r = `CloudFront-Is-SmartTV-Viewer`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_IS_TABLET_VIEWER =>
      val r = `CloudFront-Is-Tablet-Viewer`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_VIEWER_COUNTRY =>
      val r = `CloudFront-Viewer-Country`
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.HOST =>
      val r = Host
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.ORIGIN =>
      val r = Origin
      r
    case software.amazon.awssdk.services.lightsail.model.HeaderEnum.REFERER =>
      val r = Referer
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object Accept extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT
  }
  case object `Accept-Charset`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT_CHARSET
  }
  case object `Accept-Datetime`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT_DATETIME
  }
  case object `Accept-Encoding`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT_ENCODING
  }
  case object `Accept-Language`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.ACCEPT_LANGUAGE
  }
  case object Authorization
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.AUTHORIZATION
  }
  case object `CloudFront-Forwarded-Proto`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_FORWARDED_PROTO
  }
  case object `CloudFront-Is-Desktop-Viewer`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_IS_DESKTOP_VIEWER
  }
  case object `CloudFront-Is-Mobile-Viewer`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_IS_MOBILE_VIEWER
  }
  case object `CloudFront-Is-SmartTV-Viewer`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_IS_SMART_TV_VIEWER
  }
  case object `CloudFront-Is-Tablet-Viewer`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_IS_TABLET_VIEWER
  }
  case object `CloudFront-Viewer-Country`
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.CLOUD_FRONT_VIEWER_COUNTRY
  }
  case object Host extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.HOST
  }
  case object Origin extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.ORIGIN
  }
  case object Referer
      extends io.github.vigoo.zioaws.lightsail.model.HeaderEnum {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.HeaderEnum =
      software.amazon.awssdk.services.lightsail.model.HeaderEnum.REFERER
  }
}
