package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStaticIpsResponse(
    staticIps: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.StaticIp]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse = {
    import GetStaticIpsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse
      .builder()
      .optionallyWith(
        staticIps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.staticIps)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse
      .wrap(buildAwsValue())
}
object GetStaticIpsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse(
        staticIpsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def staticIpsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.StaticIp.ReadOnly]]
    def nextPageTokenValue: Option[String]
    def staticIps: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.StaticIp.ReadOnly
    ]] = AwsError.unwrapOptionField("staticIps", staticIpsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse.ReadOnly {
    override def staticIpsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.StaticIp.ReadOnly]
    ] = scala
      .Option(impl.staticIps())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.StaticIp.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetStaticIpsResponse.ReadOnly =
    new Wrapper(impl)
}
