package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseSnapshotResponse(
    relationalDatabaseSnapshot: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse = {
    import GetRelationalDatabaseSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse
      .builder()
      .optionallyWith(
        relationalDatabaseSnapshot.map(value => value.buildAwsValue())
      )(_.relationalDatabaseSnapshot)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseSnapshotResponse(
          relationalDatabaseSnapshotValue.map(value => value.editable)
        )
    def relationalDatabaseSnapshotValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly
    ]
    def relationalDatabaseSnapshot: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly
    ] = AwsError.unwrapOptionField(
      "relationalDatabaseSnapshot",
      relationalDatabaseSnapshotValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly {
    override def relationalDatabaseSnapshotValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot.ReadOnly
    ] = scala
      .Option(impl.relationalDatabaseSnapshot())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseSnapshot
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
