package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseResponse(
    relationalDatabase: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabase
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse = {
    import GetRelationalDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse
      .builder()
      .optionallyWith(relationalDatabase.map(value => value.buildAwsValue()))(
        _.relationalDatabase
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse =
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse(
        relationalDatabaseValue.map(value => value.editable)
      )
    def relationalDatabaseValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.ReadOnly
    ]
    def relationalDatabase: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.ReadOnly
    ] =
      AwsError.unwrapOptionField("relationalDatabase", relationalDatabaseValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly {
    override def relationalDatabaseValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.ReadOnly
    ] = scala
      .Option(impl.relationalDatabase())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RelationalDatabase.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly =
    new Wrapper(impl)
}
