package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  SensitiveString
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseMasterUserPasswordResponse(
    masterUserPassword: Option[SensitiveString] = None,
    createdAt: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse = {
    import GetRelationalDatabaseMasterUserPasswordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
      .builder()
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseMasterUserPasswordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseMasterUserPasswordResponse(
          masterUserPasswordValue.map(value => value),
          createdAtValue.map(value => value)
        )
    def masterUserPasswordValue: Option[SensitiveString]
    def createdAtValue: Option[IsoDate]
    def masterUserPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly {
    override def masterUserPasswordValue: Option[SensitiveString] = scala
      .Option(impl.masterUserPassword())
      .map(value => value: SensitiveString)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly =
    new Wrapper(impl)
}
