package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseLogEventsResponse(
    resourceLogEvents: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.LogEvent]
    ] = None,
    nextBackwardToken: Option[String] = None,
    nextForwardToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse = {
    import GetRelationalDatabaseLogEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse
      .builder()
      .optionallyWith(
        resourceLogEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceLogEvents)
      .optionallyWith(nextBackwardToken.map(value => value: java.lang.String))(
        _.nextBackwardToken
      )
      .optionallyWith(nextForwardToken.map(value => value: java.lang.String))(
        _.nextForwardToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseLogEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseLogEventsResponse(
          resourceLogEventsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextBackwardTokenValue.map(value => value),
          nextForwardTokenValue.map(value => value)
        )
    def resourceLogEventsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.LogEvent.ReadOnly]]
    def nextBackwardTokenValue: Option[String]
    def nextForwardTokenValue: Option[String]
    def resourceLogEvents: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.LogEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceLogEvents", resourceLogEventsValue)
    def nextBackwardToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextBackwardToken", nextBackwardTokenValue)
    def nextForwardToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextForwardToken", nextForwardTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly {
    override def resourceLogEventsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.LogEvent.ReadOnly]
    ] = scala
      .Option(impl.resourceLogEvents())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.LogEvent.wrap(item)
        }.toList
      )
    override def nextBackwardTokenValue: Option[String] =
      scala.Option(impl.nextBackwardToken()).map(value => value: String)
    override def nextForwardTokenValue: Option[String] =
      scala.Option(impl.nextForwardToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly =
    new Wrapper(impl)
}
