package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseEventsResponse(
    relationalDatabaseEvents: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse = {
    import GetRelationalDatabaseEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse
      .builder()
      .optionallyWith(
        relationalDatabaseEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationalDatabaseEvents)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseEventsResponse(
          relationalDatabaseEventsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextPageTokenValue.map(value => value)
        )
    def relationalDatabaseEventsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent.ReadOnly
    ]]
    def nextPageTokenValue: Option[String]
    def relationalDatabaseEvents: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relationalDatabaseEvents",
      relationalDatabaseEventsValue
    )
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly {
    override def relationalDatabaseEventsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent.ReadOnly
    ]] = scala
      .Option(impl.relationalDatabaseEvents())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseEvent
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly =
    new Wrapper(impl)
}
