package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{Integer, ResourceName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseEventsRequest(
    relationalDatabaseName: ResourceName,
    durationInMinutes: Option[Integer] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest = {
    import GetRelationalDatabaseEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .optionallyWith(durationInMinutes.map(value => value: java.lang.Integer))(
        _.durationInMinutes
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsRequest =
      io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsRequest(
        relationalDatabaseNameValue,
        durationInMinutesValue.map(value => value),
        pageTokenValue.map(value => value)
      )
    def relationalDatabaseNameValue: ResourceName
    def durationInMinutesValue: Option[Integer]
    def pageTokenValue: Option[String]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def durationInMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("durationInMinutes", durationInMinutesValue)
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def durationInMinutesValue: Option[Integer] =
      scala.Option(impl.durationInMinutes()).map(value => value: Integer)
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseEventsRequest.ReadOnly =
    new Wrapper(impl)
}
