package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseBlueprintsResponse(
    blueprints: Option[Iterable[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint
    ]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse = {
    import GetRelationalDatabaseBlueprintsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
      .builder()
      .optionallyWith(
        blueprints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blueprints)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseBlueprintsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseBlueprintsResponse(
          blueprintsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextPageTokenValue.map(value => value)
        )
    def blueprintsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly
    ]]
    def nextPageTokenValue: Option[String]
    def blueprints: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly
    ]] = AwsError.unwrapOptionField("blueprints", blueprintsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly {
    override def blueprintsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly
    ]] = scala
      .Option(impl.blueprints())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBlueprint
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly =
    new Wrapper(impl)
}
