package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRegionsResponse(
    regions: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Region]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRegionsResponse = {
    import GetRegionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRegionsResponse
      .builder()
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regions)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse
      .wrap(buildAwsValue())
}
object GetRegionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRegionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse(
        regionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def regionsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Region.ReadOnly]]
    def regions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Region.ReadOnly
    ]] = AwsError.unwrapOptionField("regions", regionsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRegionsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse.ReadOnly {
    override def regionsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Region.ReadOnly]] =
      scala
        .Option(impl.regions())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Region.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRegionsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRegionsResponse.ReadOnly =
    new Wrapper(impl)
}
