package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRegionsRequest(
    includeAvailabilityZones: Option[Boolean] = None,
    includeRelationalDatabaseAvailabilityZones: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRegionsRequest = {
    import GetRegionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRegionsRequest
      .builder()
      .optionallyWith(
        includeAvailabilityZones.map(value => value: java.lang.Boolean)
      )(_.includeAvailabilityZones)
      .optionallyWith(
        includeRelationalDatabaseAvailabilityZones.map(value =>
          value: java.lang.Boolean
        )
      )(_.includeRelationalDatabaseAvailabilityZones)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRegionsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRegionsRequest
      .wrap(buildAwsValue())
}
object GetRegionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRegionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetRegionsRequest =
      io.github.vigoo.zioaws.lightsail.model.GetRegionsRequest(
        includeAvailabilityZonesValue.map(value => value),
        includeRelationalDatabaseAvailabilityZonesValue.map(value => value)
      )
    def includeAvailabilityZonesValue: Option[Boolean]
    def includeRelationalDatabaseAvailabilityZonesValue: Option[Boolean]
    def includeAvailabilityZones: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "includeAvailabilityZones",
        includeAvailabilityZonesValue
      )
    def includeRelationalDatabaseAvailabilityZones
        : ZIO[Any, AwsError, Boolean] = AwsError.unwrapOptionField(
      "includeRelationalDatabaseAvailabilityZones",
      includeRelationalDatabaseAvailabilityZonesValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRegionsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRegionsRequest.ReadOnly {
    override def includeAvailabilityZonesValue: Option[Boolean] =
      scala.Option(impl.includeAvailabilityZones()).map(value => value: Boolean)
    override def includeRelationalDatabaseAvailabilityZonesValue
        : Option[Boolean] = scala
      .Option(impl.includeRelationalDatabaseAvailabilityZones())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRegionsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetRegionsRequest.ReadOnly =
    new Wrapper(impl)
}
