package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancerResponse(
    loadBalancer: Option[io.github.vigoo.zioaws.lightsail.model.LoadBalancer] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse = {
    import GetLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse
      .builder()
      .optionallyWith(loadBalancer.map(value => value.buildAwsValue()))(
        _.loadBalancer
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse
      .wrap(buildAwsValue())
}
object GetLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetLoadBalancerResponse(loadBalancerValue.map(value => value.editable))
    def loadBalancerValue
        : Option[io.github.vigoo.zioaws.lightsail.model.LoadBalancer.ReadOnly]
    def loadBalancer: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancer.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancer", loadBalancerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse.ReadOnly {
    override def loadBalancerValue
        : Option[io.github.vigoo.zioaws.lightsail.model.LoadBalancer.ReadOnly] =
      scala
        .Option(impl.loadBalancer())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.LoadBalancer.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerResponse.ReadOnly =
    new Wrapper(impl)
}
