package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetKeyPairsResponse(
    keyPairs: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.KeyPair]] =
      None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse = {
    import GetKeyPairsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse
      .builder()
      .optionallyWith(
        keyPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyPairs)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse
      .wrap(buildAwsValue())
}
object GetKeyPairsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse(
        keyPairsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def keyPairsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.KeyPair.ReadOnly]]
    def nextPageTokenValue: Option[String]
    def keyPairs: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.KeyPair.ReadOnly
    ]] = AwsError.unwrapOptionField("keyPairs", keyPairsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse.ReadOnly {
    override def keyPairsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.KeyPair.ReadOnly]
    ] = scala
      .Option(impl.keyPairs())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.KeyPair.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetKeyPairsResponse.ReadOnly =
    new Wrapper(impl)
}
