package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetInstanceStateRequest(instanceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest = {
    import GetInstanceStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceStateRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceStateRequest
      .wrap(buildAwsValue())
}
object GetInstanceStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstanceStateRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetInstanceStateRequest(instanceNameValue)
    def instanceNameValue: ResourceName
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceStateRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceStateRequest.ReadOnly =
    new Wrapper(impl)
}
