package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceSnapshotsResponse(
    instanceSnapshots: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse = {
    import GetInstanceSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse
      .builder()
      .optionallyWith(
        instanceSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceSnapshots)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse
      .wrap(buildAwsValue())
}
object GetInstanceSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse(
        instanceSnapshotsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def instanceSnapshotsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.ReadOnly]
    ]
    def nextPageTokenValue: Option[String]
    def instanceSnapshots: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceSnapshots", instanceSnapshotsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly {
    override def instanceSnapshotsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.ReadOnly]
    ] = scala
      .Option(impl.instanceSnapshots())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
