package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceSnapshotResponse(
    instanceSnapshot: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse = {
    import GetInstanceSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse
      .builder()
      .optionallyWith(instanceSnapshot.map(value => value.buildAwsValue()))(
        _.instanceSnapshot
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse
      .wrap(buildAwsValue())
}
object GetInstanceSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse =
      io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse(
        instanceSnapshotValue.map(value => value.editable)
      )
    def instanceSnapshotValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.ReadOnly
    ]
    def instanceSnapshot: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.ReadOnly
    ] = AwsError.unwrapOptionField("instanceSnapshot", instanceSnapshotValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly {
    override def instanceSnapshotValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.ReadOnly
    ] = scala
      .Option(impl.instanceSnapshot())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.InstanceSnapshot.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
